#! /bin/sh
# Usage: ./colremoval.sh <file-base> 
#
# Calls programs makegraph.pl, ChordAlg, and colremoval.zpl 
# Solves integer linear program using CPLEX 
#
# Reads files that have been processed by Dan's program to generate multi-state data
# makegraph.pl outputs graph file to <file-base>.gr and color file to <file-base>.col
# ChordAlg reads <file-base>.gr and <file-base>.col and outputs <file-base>.sep and <file-base>.lab
#     files
# zimpl reads <file-base>.sep and <file-base>.lab files and generates ILP
#

file=$1     # read file-base name

if [ $# -ne 1 ]; then
       echo 1>&2 Usage: "./colremoval.sh <file-base>"
       exit 127
fi

perl makegraph.pl $file $file.gr $file.col
./ChordAlg -amsallcolorsilp $file.gr $file.col $file.sep $file.lab 0 0 0 1

zimpl -v 0 -o $file -D input1=$file.sep -D input2=$file.lab colremoval.zpl

echo "set logfile $file.cplex
	read $file.lp
	opt
	display solution list *
	quit
	" > cplexfile;

cplex < cplexfile;
rm cplexfile;
#clear;
