# colremoval.zpl
#
# Character removal integer linear program
# Finds minimum number of characters to remove using crossing separator approach
#
# Usage: ./zimpl -v 0 -o <output> -D input1=<file.sep> -D input2=<file.lab> colremoval.zpl
#
# Reads set of separators from file <file.sep> which should have the format:
# <number-of-columns> <number-of-separators> <number-of-crossing-pairs-of-separators>
# 1 S1 S2
# 2 S1 S3 
# ...
#
# Reads set of labels from file <file.lab> which should have the format:
# <number-of-columns> <number-of-separators> <number-of-separator-label-pairs>
# 1 S1 label1
# 2 S1 label2
# ...

param m := read input1 as "1n" use 1 comment "#" ;		# number of columns
param s := read input1 as "2n" use 1 comment "#" ;		# number of separators
param e := read input1 as "3n" use 1 comment "#" ;		# number of crossing separators
param p := read input2 as "3n" use 1 comment "#" ;		# number of separator-label pairs

set C := { 0..m-1 };			# indices for columns
set S := { 1..s };			# indices for separators/vertices of graph
set E := { 1..e };			# indices for edges corresponding to separator crossings	
set P := { 1..p };			# indices for separator-label pairs
set sepcross1 := { read input1 as "<2n>" skip 1 comment "#" } ; 	# separators involved in crossings
set sepcross2 := { read input1 as "<3n>" skip 1 comment "#" } ; 	# separators involved in crossings 
set sepillegal := { read input2 as "<2n>" skip 1 comment "#" } ;	# illegal separators 

var b[C] binary;
var v[S] binary;

param Cross1[E] := read input1 as "<1n> 2n" skip 1 comment "#" ;	# read crossing separators
param Cross2[E] := read input1 as "<1n> 3n" skip 1 comment "#" ;	# read crossing separators
param Label1[P] := read input2 as "<1n> 2n" skip 1 comment "#" ;	# read separator-label pairs
param Label2[P] := read input2 as "<1n> 3n" skip 1 comment "#" ;	# read separator-label pairs

minimize cost: sum <i> in C : b[i] ;

subto c1 : forall <i> in E do 
				v[Cross1[i]] + v[Cross2[i]] <= 1 ;

subto c2 : forall <i> in sepcross1 union sepcross2 do 
				v[i] + ( sum <k> in E with Cross1[k] == i : v[Cross2[k]] ) + ( sum <k> in E with Cross2[k] == i : v[Cross1[k]] ) >= 1 ;

subto c3 : forall <i,k> in sepillegal*P with Label1[k] == i do
				( b[Label2[k]] - v[i] ) >= 0 ; 

