# Written  by Dan Gusfield,  copyright 2009
#  Permission to use this program comes with no guarantees. You may use it if you don't laugh at it and
#  #  don't expect the author to understand or explain the code in the future.
#  #  Permission is not granted for redistribution or distribution of modified versions. Please contact
#  #  the author concerning distributing any modifications.
#
# listaugmentM.pl
# Jan. 26, 2009


$ilplist = $ARGV[0];  # list of the ilps that have been solved
chomp $ilplist;
$basisfile = $ARGV[1]; # file where the solutions are found - generally the variables set to 1
chomp $basisfile;

 print "$ilplist, $basisfile \n";

open (LIST, "$ilplist");
open (INB, "$basisfile");
open (SUMMARY, '>>msummary');

open (FEAS, '>feasiblelist');
open (DATA, '>adatalist');
open (INFEAS, '>infeasiblelist');

$listflag = 0;
$line = "";
while ($ilp = <LIST>) { #process a new ilp file from the ilplist
chomp $ilp;
# print "$ilp\n";
print SUMMARY "\n$ilp\n";
$listflag = 1;

  until ($line =~ m/$ilp/) {
  $line = <INB>;
  }
   
%basis = ();
$basiscount = 0;
$sflag = 0; #this records whether we have seen any S variables for this ilp. This is needed because cplex 
            # 11 ends some ilp records (the last one in blat for example) without an `All other' or 
	    # 'No integer' line.

 $vars = 1; # this records if the ILP has variables (an ilp with  no vars should be caught by one of the
	      # Cors, but we removed Corollary checking in some cases).

until (($line =~ /EOF/) || ($line =~ m/All other/) || ($line =~ /No integer feasible/) || ($line =~ /NEW/)
|| ($line =~ /no solution exists/) || ($line =~ /no variables/))

{ # until the end of the information for that ilp result

  $line = <INB>;

  if ($line =~ /no variables/) {
	  $vars = 0;
  }

  if ($line =~ /All rows and columns/) {
	  print SUMMARY "$line";
  }
  if ($line =~ /Solution time/) {
	  print SUMMARY "$line";
  }
  if ($line =~ /Reduced MIP/) {
	  print SUMMARY "$line";
  }

  if (($line =~ /Presolve - Infeasible/) || ($line =~ /Infeasibility/)){
	  print SUMMARY "$line";
  }

if ($line =~ m/S(\d+) +(\d)/) {
  $sflag = 1;
#  print OUTS "svars $1\n";
  if ($2 == 1) {
  $basis{$1} = 1;
  $basiscount++;
  }
}

}

$ilp =~ /(\d+)mppilp.(\d+)/;

$tsep = "t$1sep.$2";
$states = $1;
$ext = $2;

open (TSEP, "$tsep");
$source = <TSEP>;
chomp $source;

$source =~ /(\d+)state(\d+).(\d+).(\d+)/;
# print "$source\n";

  if (($states != $1) || ($ext != $4)) {
	  print "Inconsistency\n";
  exit;
  }

# Now process the S variables if any were found 
if (($line =~ /All other/) || ($sflag)) {
print FEAS "$ilp\n";
print DATA "a$source\n";

open (M, "$source");
open (MM, ">a$source");


$line = <M>;
  print MM ("$line");
$line = <M>;
  $line =~ /(\d+) (\d+)/;
  $rows = $1;
  $chars = $2;
  $rows += $basiscount;
  print MM ("$rows $chars\n");

while ($line = <M>) {
  print MM ("$line");
}

while ($line = <TSEP>) {
   if ($line =~ /^S(\d+)/) {
      if ($basis{$1} == 1) {
	$c = $chars-1;
        foreach $i (0..$c) {
	  $dataline[$i] = '?';
        }
          $line = <TSEP>;
            while ($line =~ /(\d+),(\d+)?/g) {
#	      print "$1 , $2 \n";
	        $dataline[$1-1]  = $2;
            }

      $string = join(' ', @dataline);
      print MM ("$string\n");
      }
     }
   }
close(M);
close(MM);
}

else { 
	if ($vars) {
          print INFEAS "$ilp\n";
          print SUMMARY "$ilp is infeasible, so no PP\n";
        }
}
} # end of while loop

if ($listflag == 0) {
	exit 1;
}
