# Written  by Dan Gusfield,  copyright 2009
#  Permission to use this program comes with no guarantees. You may use it if you don't laugh at it and
#  #  don't expect the author to understand or explain the code in the future.
#  #  Permission is not granted for redistribution or distribution of modified versions. Please contact
#  #  the author concerning distributing any modifications.
#
# mppilp.pl
#
# Feb. 3, 2009 Extend to collect stats
#Jan. 25, 2009
#
# Jan. 24, 2009 Modify to write three lists, ilplist, applist, and nopplist of the ilps that 
# were fully generated, the ilps that were not generated because there are no illegal min seps,
# and the ilps that were only partialy generated, because an illegal min sep was found which
# was not crossed by any legal min sep - a case when we know for sure that there will be no PP.
# In the first case we have to run the ILP to determine if there is a PP. In the second case
# we know there is a PP, and in the third case we know there is no PP. Program ppilp.pl does not have
# the second case because it processes the lines while reading them in rather than reading to
# the bottom first.
#
#Modify to maximize the number of legal separators chosen, subject to the constraints below.
# This guarantees that a maximal set of pairwise parallel legal min. seps. are chosen,
# which is what is needed in order to actually get a PP. The ILP otherwise just determines IF
# there is a PP solution.
#
# Produce the ILP that determines if there is a set of pairwise parallel legal minimal separators
# that cross all the illegal minimal separators.
#

$VERBOSE = 0;
open (TSEP, $ARGV[0]);
open (OUT, ">$ARGV[1]");
open (SUMMARY, '>>msummary');
#    print OUT "Minimize 0
    print OUT "Maximize \n";
$legalcrosslegal = 0;
$crossillegal = 0;
$Scount = 0;

    $tsep = $ARGV[0];
#    print "$tsep\n";
#    $tsep =~ /t(\d+)sep.(\d+)/;
    $tsep =~ /t(\d+).*sep.(\d+)/; # Jan. 28, 2009 change so that t(\d+)csep will be matched.
    $ilp = "$1mppilp.$2.lp";  # This is the file that the ilp or partial ilp will go.

 @data = <TSEP>;
    $obcount = 0;
    foreach $line (@data) {
       if ($line =~ /^S(\d+):/) {
        $currentS = $1;
       }
       if ($line =~ /is.+ legal/) {
          print OUT "+S$currentS ";
            $bin{$currentS} = 1;
 
            $obcount++;
            if ($obcount > 8) {
              print OUT "\n";
              $obcount = 0;
        }
       }
      if ($line =~ / 0 illegal/) {
         open (APP, '>>applist');
         print APP "$ilp\n";
         print SUMMARY "Automatic PP solution by Cor 2 since there are no illegal min seps\n";
         close (OUT);
         exit;
      }

}
print OUT "\nsuch that\n";

    foreach $line (@data) {
       if ($line =~ /^S(\d+):/) {
          $currentS = $1;
          $illegal{$currentS} = 0;
       }
       if ($line =~ /an illegal/) {
if ($VERBOSE){
          print OUT "S$currentS is illegal\n";
}
          $illegal{$currentS} = 1;
            $const{$currentS} = "";
       }

       if ($line =~ /Cross .*S(\d+)/) {
          $crossingS = $1;
           if ($currentS > $crossingS) {

             if (($illegal{$currentS} == 0) && ($illegal{$crossingS} == 0)) {
              print OUT "S$currentS + S$crossingS <= 1\n";
	      $legalcrosslegal++;
	      if (!defined $Sbin{$currentS}) {
		      $Scount++;
	      }
	      if (!defined $Sbin{$crossingS}) {
		      $Scount++;
	      }
              $Sbin{$currentS} = 1;
              $Sbin{$crossingS} = 1;
             }

              if (($illegal{$currentS} == 1) && ($illegal{$crossingS} == 0)) {
                $const{$currentS} .= "+ S$crossingS";
	      if (!defined $Sbin{$crossingS}) {
		      $Scount++;
	      }
                $Sbin{$crossingS} = 1; 
              }
          
              else {
                   if (($illegal{$crossingS} == 1) && ($illegal{$currentS} == 0)) {
                   $const{$crossingS} .= "+ S$currentS";
	           if (!defined $Sbin{$currentS}) {
		      $Scount++;
	           }
                   $Sbin{$currentS} = 1;
                   }
              }
           }
       }
      }

if ($VERBOSE) {
      print OUT "The illegal seps are:\n";
}
      foreach $sep (sort {$a <=> $b} keys %illegal) {
        if ($illegal{$sep}) {
        
if ($VERBOSE) {
          print OUT "S$sep\n";
}
	  if ($const{$sep} eq "") {
	     print OUT "The illegal separator S$sep is not crossed by any legal separator, so 
there can be no PP\n";
	     print SUMMARY "The illegal separator S$sep is not crossed by any legal separator, so there can be no PP by Cor 1\n";
    open (NOILPLIST, '>>nopplist');
    print NOILPLIST "$ilp\n";
    close (OUT);
             exit;
          }
          else {
	       print OUT "$const{$sep} >= 1\n";
	       $crossillegal++;
	  }
        }
      }

    print OUT "binaries\n";

    foreach $sep (sort {$a <=> $b} keys %bin) {
        print OUT "S$sep\n";
    }
  if ($legalcrosslegal > 0) {
    print OUT "end";
    open (ILPLIST, '>>ilplist');
    print ILPLIST "$ilp\n";
    print SUMMARY "$ilp must be solved\n";
    print SUMMARY "There are $Scount crossing legal variables\n";
    print SUMMARY "There are $crossillegal inequalities describing legal min seps crossing illegal min seps\n";
    print SUMMARY "There are $legalcrosslegal pairs of crossing legal min seps\n";
    close (OUT);
}

else {
         open (APP, '>>applist');
         print APP "$ilp\n";
         print SUMMARY "Automatic PP solution by Cor 3 since every illegal min sep is crossed by a legal
	 min sep, and there is no pair of crossing legal min. seps. \n";
         close (OUT);
}
