#!/pkg/bin/perl -w
# r2.pl
# Written  by Dan Gusfield  copyright 2014 
# Permission to use this program comes with no guarantees. You may use it if you don't laugh at it and
# don't expect the author to understand the code in the future.
#
#
 use diagnostics
# Generates a small ILP to solve the problem of
# setting the X values in Rasmus's haplotyping problem. This computes the actual Phenotypic Distance (Hamming distance). It is a modification of
#rasmus2.pl  
# June 14, 2014
#
open IN, "$ARGV[0]"; # The file where the binary data is.
$dataset = $ARGV[0];
open OUTC, ">constraints";
open OUTO, ">objective";
open OUTLOG, ">>outlog";
$line1 = <IN>;
$line1 =~ /(\d+.\d+)/; #extract the numerical extension -- consists of two numbers with a . between
$setnumber = $1;  # assign what was extracted to $setnumber


$line2 = <IN>;
($numpairs, $col) = split(/ /, $line2);  # extract and split the information from the next line into
                                         # $numpairs and $col
print "$numpairs, $col\n";

@lines = <IN>;
chomp @lines;

$left = 0;
$right = $col -1; # right and left now define the range of the indices into the data. 
$obj0 = $obj1 = "";
$binaryZ = "";
$tcount0 = $tcount1 = 0;
$obj0count = $obj1count = 0;
 foreach $pair (0...$numpairs-1) {
    @data1 = split(/ /, $lines[3 * $pair]);
    @data2 = split(/ /, $lines[1 + 3 * $pair]);
#    print "X, $pair \n";

 $target = $lines[2+3*$pair];
#  print "target is $target \n";


 $CON1 = $CON2 = ""; 
 if ($target == 1) {
    $tcount1++; 
    $obj1 .= "+ W$pair ";
    $obj1count++;
    if ($obj1count%10 == 0) {
        $obj1 .= "\n";
    }
    foreach $j ($left ... $right) {
      if ($data1[$j] == 1) {
        $CON1 .= "- X$j ";
      }
      if ($data2[$j] == 1) {
         $CON2 .=  "- X$j ";
      }
    }
    $CON1 .=  "+ W$pair <= 0\n";
    $CON2 .=  "+ W$pair <= 0\n";
    print OUTC "$CON1";
    print OUTC "$CON2";
 }

 else {
    $tcount0++;
    $obj0 .= " - W$pair ";
    $obj0count++;
    if ($obj0count%15 == 0) {
        $obj0 .= "\n";
    }
    $count2 = $count1 = 0;
    foreach $j ($left ... $right) {
      if ($data1[$j] == 1) {
        $CON1 .= "+ X$j ";
        $count1++;
      }
      if ($data2[$j] == 1) {
         $CON2 .= " + X$j ";
         $count2++;
      }
    }
    $CON1 .= "- $count1 Z$pair,1 <= 0\n";
    $CON2 .= "- $count2 Z$pair,2 <= 0\n";
    $binaryZ .= "Z$pair,1\n";
    $binaryZ .= "Z$pair,2\n";

    print OUTC "$CON1";
    print OUTC "$CON2";
    $CON = "Z$pair,1 + Z$pair,2 - W$pair <= 1\n";
    print OUTC "$CON";
 }
}

# $binaryW = "binaries \n";
print OUTC "binaries \n";
 foreach $pair (0...$numpairs-1) {
#    $binaryW .= "W$pair\n";
    print OUTC "W$pair\n";
 }
# $binaryX = "";
 foreach $i ($left ... $right) {
#    $binaryX .= "X$i\n";
    print OUTC "X$i\n";
 }
 print OUTC "$binaryZ";
 print  OUTC "end";

print OUTO "minimize Z \n subject to \n\n";
print OUTO "Z $obj1 $obj0  = $tcount1 \n\n";
print OUTLOG "setnumber, tcount0, tcount1: $setnumber, $tcount0, $tcount1\n";

$outputfile = "$dataset.lp";
system ("cat objective constraints > $outputfile");
print "The output is in file $outputfile\n";

close(OUTLOG);
