# s_praspipe.pl
#
# pipeline for running a collection of Rasmus's simulated datasets. 
#
# We assume that the datafile has a collection of datasets, where the first one is
# for a causal gene, and the others are for non-causal genes. All of the datasets have the
# same vector of phenotypes, which is for the causal gene.
# To run this program, use: Perl s_praspipe.pl name_of_the_datafile
#
# Updated December 24, 2014, Feb. 5, 2015, Feb. 9, 2015
# Dan Gusfield
#
$data = $ARGV[0]; # the datafile from Rasmus, which should be given as a parameter when s_praspipe.pl is run.

system ("rm datalist");

system ("perl multextract_for_Gwas.pl $data 0"); # extract and convert the individual datasets to individual files in my format.
                                                 # start indexing the datasets from the parameter (here 0). Write the file
                                                 # names to file `datalist'; compute the objective function of the correct SNPs
                                                 # and write that along with the correct SNPs to file trueSNPs.

open (DATA, "datalist"); 
@datalist = <DATA>;

system ("rm gurobi.log");
system ("rm blat");
open (DLIST, 'datalist');

while ($dataset = <DLIST>) { # process each data file in datalist
  chomp $dataset;
                           

  system ("perl r2.pl $dataset"); # call r2.pl, the Perl program to create the ILP for the dataset. 
                                  # The ILP for the dataset is written to file $dataset.lp 


  system ("python callback1.py $dataset.lp $dataset.sol"); # This calls gurobi to solve  the 
                                                           # ILP in $dataset.lp and put the result in $dataset.sol

}
system ("perl listcollectstats.pl comps");    # Call the Perl program to collect information from gurobi.log and $datalist and
                                              # trueSNPs,  and each $dataset.sol and output the result in file comps.

close DLIST;

system ("perl datascan.pl comps"); # process comps to extract information for a latex table called compstable.
system ("pdflatex compstable"); # pdflatex compstable to produce compstable.pdf

