// C++ code
// upperbound.cpp
// Author: Yun S. Song
// October 2004


//  10/22/04  Modified so that LBMap, PathScoreMap are now of mapVec2Short type

#include <iostream>
#include <vector>
#include <map>
#include "basicdefs.h"
#include "fastlowerbound.h"

typedef std::map<vector<bool>, unsigned short> mapVec2Short;

// Here, seqSet is a set of remaining sequences after givenSeq got removed
// computes the minumum number of rec events required to derive a given seq 
// from a set of sequences
unsigned int recWeight(const vector<bool> &givenSeq, const BinMatrix & seqSet){

  unsigned int position=0, numRec=0, maxMatchLength=0, curMatchLength;
  unsigned int iC,iR;


  // scan along the sequence length and find maximal matches
  while(position < givenSeq.size()){
    for(iR=0; iR < seqSet.rowsize(); iR++){
      curMatchLength=0;
      for(iC=position; iC < givenSeq.size(); iC++){
	if(seqSet[iR][iC]==givenSeq[iC]){
	  curMatchLength++;
	}
	else{
	  break;
	}
      }
      if(curMatchLength > maxMatchLength) maxMatchLength=curMatchLength;
    }

    position += maxMatchLength;
    if(position < givenSeq.size()) numRec++; // need more recombination
    maxMatchLength=0;
  }
  return numRec;
}

// Here, seqSet is a set of before row2BRemoved gets removed
// computes the minumum number of rec events required to derive a given seq 
// from a set of sequences
unsigned int recWeight(const unsigned int row2BRemoved, const BinMatrix & seqSet){

  unsigned int position=0, numRec=0, maxMatchLength=0, curMatchLength;
  unsigned int iC,iR;

  // scan along the sequence length and find maximal matches
  while(position < seqSet.colsize()){
    for(iR=0; iR < row2BRemoved; iR++){
      curMatchLength=0;
      for(iC=position; iC < seqSet.colsize(); iC++){
	if(seqSet[iR][iC]==seqSet[row2BRemoved][iC]){
	  curMatchLength++;
	}
	else{
	  break;
	}
      }
      if(curMatchLength > maxMatchLength) maxMatchLength=curMatchLength;
    }
    for(iR=row2BRemoved+1; iR < seqSet.rowsize(); iR++){
      curMatchLength=0;
      for(iC=position; iC < seqSet.colsize(); iC++){
	if(seqSet[iR][iC]==seqSet[row2BRemoved][iC]){
	  curMatchLength++;
	}
	else{
	  break;
	}
      }
      if(curMatchLength > maxMatchLength) maxMatchLength=curMatchLength;
    }
    position += maxMatchLength;
    if(position < seqSet.colsize()) numRec++; // need more recombination
    maxMatchLength=0;
  }
  return numRec;
}


// input data is completely reduced, but still contains some incompatibility
// find an upperbound on the number of recombination events
void upperbound(const BinMatrix & inData, unsigned int cur_tot, unsigned int *best, const vector<unsigned short> &cur_path, vector<unsigned short> &optimal_path, const vector<unsigned short> & RMap){

  //  used for debugging
  //  extern unsigned int numberOfRuns;   numberOfRuns++;  

  BinMatrix modifiedData;
  vector<unsigned short> NewRMap;
  extern  short displayARG;
  extern unsigned short reducedMatRowSize;
  extern mapVec2Short LBMap, PathScoreMap;
  extern short flbMethod;
  vector<unsigned short> new_path=cur_path;
  unsigned int new_tot;
  unsigned short iR;
  unsigned int tmpCrudeBound;
  vector<bool> tmpBoolVec;

  // We will consider removing a row one by one
  for(iR=0; iR < inData.rowsize(); iR++){
    new_path.push_back(RMap[iR]);
    new_tot=cur_tot+recWeight(iR,inData);  // new score

    NewRMap=RMap;
    modifiedData=removeAndReduce(iR,inData,NewRMap); // remove row iR and reduce the
                                                     // remaining data
                                                     // NewRMap gets modified here

    tmpBoolVec=convert2BoolVec(NewRMap,reducedMatRowSize);
    if(PathScoreMap[tmpBoolVec]==0 || new_tot < PathScoreMap[tmpBoolVec]){ 
      PathScoreMap[tmpBoolVec]=new_tot;
      if(modifiedData.rowsize() < 4){  // no more incompatibility
	if(*best > new_tot){
	  *best=new_tot;
	  cerr << *best << " ";
	  if(displayARG > 0) optimal_path=new_path;
	}
      }
      else{

	if(LBMap[tmpBoolVec]==0){
	  LBMap[tmpBoolVec]=fastlowerbound(modifiedData,flbMethod);
	}
	tmpCrudeBound=LBMap[tmpBoolVec];

	//	  tmpCrudeBound=fastlowerbound(modifiedData,flbMethod);


	// check whether further removal has a chance of improving the bound.
	// If fastbound is too good, then sometimes no further removal has a chance.
	// This is not good if we want to display an ARG, for we need to record
	// an optimal sequence of removals.  So, if displayARG==1, we need to 
	// complete at least one history until only one sequence remains.

	if(new_tot+tmpCrudeBound < *best){ 
	  upperbound(modifiedData, new_tot, best,new_path,optimal_path,NewRMap);
	}
      }
    }
    tmpBoolVec.clear();
    NewRMap.clear();
    modifiedData.clear();
    new_path.resize(new_path.size()-1);
  }
}
 
