#ifndef GENERATE_ARG_H
#define GENERATE_ARG_H

#include "basicdefs.h"
#include "myMatrix.h"

void fprintNode(unsigned int,ofstream&);

void fprintLeaf(unsigned int,ofstream&);

void fprintRecNode(unsigned int,ofstream&);

void fprintEdge(unsigned int, unsigned int, const char *, ofstream&);

void printEdge(unsigned int,unsigned int);

void humanPrintEdge(unsigned int head, unsigned int tail, ofstream &outgraph);

BinMatrix coalesceTrack(const BinMatrix &, vector<unsigned int> &, vector<unsigned short> &, ofstream &);

BinMatrix killNonInfTrack(const BinMatrix &inMat);

BinMatrix collapseColTrack(const BinMatrix &inMat);

BinMatrix reduceTrack(const BinMatrix &, vector<unsigned int> &, vector<unsigned short> &, ofstream &);

void recTrack(const unsigned int, const BinMatrix &, vector<unsigned int> &,ofstream &);

void generateARG(const BinMatrix &, const vector<unsigned short> &, char *);


class BreakPoint
{
 public:  
  unsigned int left, right; 

  // Constructor
  BreakPoint() {}
  BreakPoint(unsigned int leftPos, unsigned int rightPos){
    left=leftPos;
    right=rightPos;
  }
  void display() const;
};


#endif
