# Written  by Dan Gusfield,  copyright 2009
#  Permission to use this program comes with no guarantees. You may use it if you don't laugh at it and
#  #  don't expect the author to understand or explain the code in the future.
#  #  Permission is not granted for redistribution or distribution of modified versions. Please contact
#  #  the author concerning distributing any modifications.
#
#This collects and summarizes statistics from file msummary.
#
#summstats.pl
#
open (IN, 'msummary');
open (SUMM, '>>mstats');
while ($line = <IN>) {
#	print "$line";
	if ($line =~ /END/) {
		exit;
	}

	if ($line =~ /New processing/) {
		$samplesize = $sepsamplesize = $tnodecount = $tedgecount = $tlegal = $tillegal = $tcpu = $cor1 = $cor2 = $cor3 = $dense = $tdense = $tcrossing = $tinequal = $tpairs = $allelim = $ilptime = 
$infeasibles = 0;
		print SUMM "\n$line";
		$line = <IN>;
		$line = <IN>;
		# print "$line";
		if (($line =~ /(\d+)state(\d+).(\d+).+, (\d+.\d+)/) or 
	         ($line =~ /(\d+)state(\d+).(\d+).+, (0)/))  {
		 $states = $1;
		 $n = $2;
		 $m = $3;
		 $delete = 100 * $4;
	        }
		print SUMM "$states states problem size = $n by $m, percent delete = $delete\n";

		until (($line =~ /\*\*/) or ($line =~ /END/)) {
			$line = <IN>;
			#	print "$line"; 
			if ($line =~ /dense/) {
				$tdense++;
                                $dense = 1;
			}

			if ($line =~ /(\d+.\d+) CPU/) {
				if ($dense) {
				       $densecpu += $1;
			               $dense = 0;
			        }	       
				else {
				$tcpu += $1;
				$sepsamplesize++;
			}
			}

			if ($line =~ /nodecount (\d+) edgecount (\d+)/)  {
				$samplesize++;
				$tnodecount += $1;
			        $tedgecount += $2;
			}	
			if ($line =~ /^(\d+) legal.+ (\d+) illegal/) {
				$tlegal += $1;
				$tillegal += $2;
			}

			if ($line =~ / (\d+) crossing/) {
				$tcrossing += $1;
			}

			if ($line =~ / (\d+) inequalities/) {
				$tinequal += $1 ;
			}

			if ($line =~ / (\d+) pairs/) {
				$tpairs += $1;
			}
			 
			if ($line =~ /All rows and columns eliminated/) {
				$allelim++;
			}
			 if ($line =~ /Solutiont time =.+(\d+\.\d+)/ ) {
				 $ilptime += $1;
			 }

			 if ($line =~ /infeasible/ ) {
				 $infeasibles++;

			 }

			 if ($line =~ /Presolve - Infeasible/ ) {
				 $preinfeasibles++;

			 }


			if ($line =~ /Cor (\d+)/) {
					$case = $1;
					if ($case == 1) {
						$cor1++;
					}
					if ($case == 2) {
						$cor2++;
					}
					if ($case == 3) {
						$cor3++;
					}
		        }
		}
			$avgnodecount = $tnodecount/$samplesize;
			$avgedgecount = $tedgecount/$samplesize;
			$avglegal = $tlegal/$sepsamplesize;
			$avgillegal = $tillegal/$sepsamplesize;
			$avgcpu = $tcpu/$sepsamplesize;
                        $pcor1 = 100 * $cor1/$samplesize;
                        $pcor2 = 100 * $cor2/$samplesize;
                        $pcor3 = 100 * $cor3/$samplesize;
                        $pdense = 100 * $tdense/$samplesize;

			print SUMM  "samplesize = $samplesize; average node count = $avgnodecount; average edge count = $avgedgecount\n";
			print SUMM "number of cases where all seps computed: $sepsamplesize\n";
			print SUMM "average setup cpu time for those cases = $avgcpu\n";

			print SUMM "average number of legal and illegal min seps in those cases = $avglegal, $avgillegal\n";
			print SUMM "$pdense, $pcor1, $pcor2, and $pcor3:  percent of the instances were solved by density or by Corollaries 1, 2 and 3\n";
			$ilpcount = $sepsamplesize - $cor1 - $cor2 - $cor3;
			$ilpcount1 = $samplesize - $tdense - $cor1 - $cor2 - $cor3;
			if ($ilpcount != $ilpcount1) {
				print "Something wrong in ilp counting\n";
			}
			else {
				print SUMM "The number of ilps created is $ilpcount\n";
				if ($ilpcount > 0) {
   				  $avgvars = $tcrossing/$ilpcount;
				  $avgconstr = ($tinequal + $tpairs) / $ilpcount;
				  print SUMM "average number of ilp variables and constraints = $avgvars, $avgconstr\n";
				  $pelim = 100 * $allelim/$ilpcount;
				  print SUMM "percent of ilps solved in the preprocessor = $pelim\n";
				  $pinfeasible = 100 * $infeasibles/$ilpcount;
				  print SUMM "number and percentage of ilps that are infeasible: $infeasibles, $pinfeasible - showing no PP\n";
				  print SUMM "Total ilp solution time = $ilptime\n";
			        }
			}
	}
}
