# Written  by Dan Gusfield,  copyright 2009
#  Permission to use this program comes with no guarantees. You may use it if you don't laugh at it and
#    don't expect the author to understand or explain the code in the future.
#    Permission is not granted for redistribution or distribution of modified versions. Please contact
#    the author concerning distributing any modifications.
#
#septranslate.pl
#
open (SEP, $ARGV[0]);
open (TRANS, $ARGV[1]);
open (OUT, ">t$ARGV[0]");
open (SUMMARY, '>>msummary');

$source = $ARGV[2];
print OUT "$source\n";

while ($line = <TRANS>) {
	chomp $line;
	$line =~ /(\d+) (\(\d+,\d+\))/;
	$trans{$1} = $2;
}
$illegalcount = 0;
$legalcount = 0;
while ($line = <SEP>) {
        if ($line =~ /^S/) {
		print OUT "__________________________\n";
	chomp $line;
        $line =~ tr/ //d;
        $line =~ /{(.*)}/;
        $list = $1;
        $illegal = 0;

	%seen = ();
	$keystring = "";
	@nodes = split(/,/, $list);
        foreach $node (@nodes) {
		$key = $trans{$node};
		$keystring .= $key;
		($char,$state) = split(/,/, $key);
		if (defined $seen{$char}) {
			$illegal = 1;
		}
		$seen{$char} = $state;
	}
	print OUT "$line\n";
	print OUT "$keystring\n";
	if ($illegal) {
                $illegalcount++;
		print OUT "This is an illegal separator\n";
	}
        else {
             $legalcount++;
             print OUT "This is legal\n";
        }
	print OUT "\n";
     }

     else {
	if ($line =~ /^C\d/) {
	chomp $line;
        $line =~ tr/ //d;
        $line =~ /{(.*)}/;
        $list = $1;

	$keystring = "";
	@nodes = split(/,/, $list);
        foreach $node (@nodes) {
		$key = $trans{$node};
		$keystring .= $key;
		($char,$state) = split(/,/, $key);
	}
	print OUT "$line\n";
	print OUT "$keystring\n";
	print OUT "\n";
     }
       else {
	if (!(($line =~ /^Crossings: $/)) && (!($line =~ /^$/))) {
            print OUT "$line";
        }
       }
     }
}
print OUT "$legalcount legal separators and $illegalcount illegal separators\n";
print SUMMARY "$legalcount legal separators and $illegalcount illegal separators\n";

