// C++ code
// basicdefs.h
// 


#ifndef BASICDEFS_H
#define BASICDEFS_H

#include <iostream>
#include <vector>
#include <set>
#include "myMatrix.h"

using namespace std;

template <typename T>
void printVec(const vector<T> &vec ){
  for(unsigned int i=0; i < vec.size(); i++)
    cout << vec[i] << " ";
  cout << endl;
}

template <typename T>
void printVecPlusOne(const vector<T> &vec ){
  for(unsigned int i=0; i < vec.size(); i++)
    cout << vec[i]+1 << " ";
  cout << endl;
}

template <typename T>
void printVecSet(const vector<T> &vec ){
  cout << "{" ;
  unsigned short iN;
  for(iN=0; iN < vec.size()-1; iN++)
    cout << vec[iN] << ", ";
  cout << vec[vec.size()-1] << "}";
}

void progdesc();

unsigned short max(const unsigned short, const unsigned short);

unsigned short maxOf4(const unsigned short *, const unsigned short* ,const unsigned short*, unsigned short);


void newline();

void smallspace();

void removeEntry(const unsigned int, vector<unsigned int> &);

void getoptions(int argc, char *argv[], char **, char **);

vector<unsigned int> table(unsigned int, unsigned int);

vector<unsigned short> table(unsigned short, unsigned short);

vector<unsigned short> brokenTable(unsigned short , unsigned short , unsigned short );

vector<bool> conjugate(const vector<bool> &);

bool sameHapQ(const BinMatrix &, const unsigned int, const unsigned int, const unsigned int, const unsigned int );
bool sameHapQ(const BinMatrix &, const unsigned int, const unsigned int);

unsigned int countUniqueRows(const BinMatrix &);

unsigned int countUniqueCols(const BinMatrix &);

unsigned short dRow_dCol(const BinMatrix &);

unsigned int maxOfVec(const vector<unsigned int> &);

BinMatrix coalesce(const BinMatrix &, vector<unsigned short> &);
BinMatrix coalesce(const unsigned short , const BinMatrix &, vector<unsigned short> &);
BinMatrix coalesceFL(const BinMatrix &);

BinMatrix killNonInf(const BinMatrix &);

BinMatrix collapseCol(const BinMatrix &);

BinMatrix reduceData(const BinMatrix &, vector<unsigned short>&);

BinMatrix removeAndReduce(const unsigned short , const BinMatrix &, vector<unsigned short> & );

BinMatrix getReducedSubMat(const BinMatrix & , const unsigned int, const unsigned int );

BinMatrix removeRow( unsigned int, const BinMatrix &, vector<unsigned short>&);

vector<unsigned short> complement(const vector<unsigned short> &, unsigned short );

//vector<unsigned long>powerOf2(const unsigned int length);
//unsigned long map2long(const vector<unsigned short>& inVec);

vector<bool> convert2BoolVec(const vector<unsigned short> & inVec, const unsigned short length);

vector<unsigned short> randomlySelect(const vector<unsigned short> &inVec, const unsigned short );

double uni01(long *irandomseed);
unsigned short UDRandom(unsigned short size);
void ReadSeed();
void WriteSeed();

#endif
