// C++ code
// fastupperbound.cpp
// Author: Yun S. Song
// October 2004

#include <iostream>
#include <vector>
#include <map>
#include "basicdefs.h"
#include "fastlowerbound.h"
#include "fullupperbound.h"

//  10/22/04  Modified so that LBMap, PathScoreMap are now of mapVec2Short type

typedef std::map<vector<bool>, unsigned short> mapVec2Short;

// find the minimum value of w(i|A-i)+L(A-i)
//
unsigned short findGoodBranch(const BinMatrix &inData,  const vector<unsigned short> &RMap){

  extern mapVec2Short LBMap;
  extern short flbMethod;
  extern unsigned short reducedMatRowSize;
  unsigned short weight; // rec weight
  unsigned short fastLB; // fast lower bound
  unsigned short sumScore;  // sum of rec weight and fast lower bound
  unsigned short iR;
  BinMatrix modifiedDat;
  vector<unsigned short> vecNewRMap;
  unsigned short cur_min=10000;
  vector<bool> tmpBoolVec;

  for(iR=0; iR < inData.rowsize(); iR++){
    weight=recWeight(iR,inData);
    vecNewRMap=RMap;
    modifiedDat=removeAndReduce(iR,inData,vecNewRMap); //vecNewRMap gets redefined here

    //    new_path.push_back(RMap[iR]);

    tmpBoolVec=convert2BoolVec(vecNewRMap,reducedMatRowSize);
    if(modifiedDat.rowsize() > 3 && LBMap[tmpBoolVec]==0){
      LBMap[tmpBoolVec]=fastlowerbound(modifiedDat,flbMethod);
    }
    fastLB=LBMap[tmpBoolVec];
    tmpBoolVec.clear();

    //    new_path.resize(new_path.size()-1);
    sumScore=weight+fastLB;
    if(sumScore < cur_min) cur_min=sumScore;
  }
  return cur_min;
}


void fastupperbound(const BinMatrix &inData, unsigned int cur_tot, unsigned int *best,const vector<unsigned short> &cur_path, vector<unsigned short> &optimal_path, const vector<unsigned short> &RMap){

  //  used for debugging
  //  extern unsigned int numberOfRuns;  numberOfRuns++;

  vector<unsigned short> new_path=cur_path;
  extern mapVec2Short LBMap, PathScoreMap;
  extern short displayARG;
  extern short flbMethod;
  extern unsigned short reducedMatRowSize, maxRows2Look;
  //  extern unsigned short MAX_U_SHORT;
  extern std::map<unsigned short, unsigned short> ScoreMap;
  extern unsigned int currentRun;
  vector<unsigned int> weight(inData.rowsize()); // rec weight
  vector<unsigned int> fastLB(inData.rowsize()); // fast lower bound
  vector<unsigned int> sumScore(inData.rowsize());  // sum of rec weight and fast lower bound
  unsigned short iR;
  unsigned int cur_min=10000, cur_min2=10000, new_tot;
  vector<BinMatrix> modifiedDat(inData.rowsize());
  vector<vector<unsigned short> > vecNewRMap(inData.rowsize());

  vector<vector<bool> > tmpBoolVec(inData.rowsize());
  vector<unsigned short> needToConsider(inData.rowsize());  // rows to consider removing
  unsigned short nPassedTest=0;
  vector<unsigned short> firstPass;

  for(iR=0; iR < inData.rowsize(); iR++){
    weight[iR]=recWeight(iR,inData);
    vecNewRMap[iR]=RMap;
    modifiedDat[iR]=removeAndReduce(iR,inData,vecNewRMap[iR]); //vecNewRMap gets redefined here

    tmpBoolVec[iR]=convert2BoolVec(vecNewRMap[iR],reducedMatRowSize);
    if(LBMap[tmpBoolVec[iR]]==0 && modifiedDat[iR].rowsize() > 3){
      LBMap[tmpBoolVec[iR]]=fastlowerbound(modifiedDat[iR],flbMethod);
    }
    fastLB[iR]=LBMap[tmpBoolVec[iR]];
    //    tmpBoolVec.clear();
    sumScore[iR]=weight[iR]+fastLB[iR];

    if(sumScore[iR] < cur_min) cur_min=sumScore[iR];
  }
  if(cur_tot+cur_min < *best){
    for(iR=0; iR < inData.rowsize(); iR++){  // clearing non-minimal modified data
      if(sumScore[iR]!=cur_min){
	modifiedDat[iR].clear();
	vecNewRMap[iR].clear();
	tmpBoolVec[iR].clear();
      }
      else{
	if(maxRows2Look == 1 && flbMethod==1 && inData.rowsize() == reducedMatRowSize){
	  firstPass.push_back(iR);
	  // looking forward one more step
	  if(currentRun==0){
	    ScoreMap[iR]=weight[iR]+findGoodBranch(modifiedDat[iR],vecNewRMap[iR]);
	  }
	  if(ScoreMap[iR] < cur_min2) cur_min2=ScoreMap[iR];
	}
	else{
	  needToConsider[nPassedTest]=iR;
	  nPassedTest++;
	}
      }
    }
    if(maxRows2Look == 1 && flbMethod==1 && inData.rowsize() == reducedMatRowSize){
      for(iR=0; iR < firstPass.size(); iR++){ 
	if(ScoreMap[firstPass[iR]]==cur_min2){
	  needToConsider[nPassedTest]=firstPass[iR];
	  nPassedTest++;
	}
	else{
	  tmpBoolVec[firstPass[iR]].clear();
	}
      }
    }
    needToConsider.resize(nPassedTest);
    //    printVec(needToConsider);
    // randomizing 
    /*
    if(maxRows2Look != MAX_U_SHORT){
      if(maxRows2Look < needToConsider.size()){
	needToConsider=randomlySelect(needToConsider,maxRows2Look);
      }
      else{
	needToConsider=randomlySelect(needToConsider,needToConsider.size());
      }
    }
    */

    if(maxRows2Look < needToConsider.size()){ 
      needToConsider=randomlySelect(needToConsider,maxRows2Look);
    }

    //    cout << "After perm "; printVec(needToConsider);
    for(iR=0; iR < needToConsider.size(); iR++){
      // consider removing row iR if its corresponding score is min
      new_tot=cur_tot+weight[needToConsider[iR]];

      if(maxRows2Look < 2 || PathScoreMap[tmpBoolVec[needToConsider[iR]]]==0 || new_tot < PathScoreMap[tmpBoolVec[needToConsider[iR]]]){ 
      //      if(maxRows2Look < PathScoreMap[tmpBoolVec]==0 || new_tot < PathScoreMap[tmpBoolVec]){ 
      	if(maxRows2Look >= 2) PathScoreMap[tmpBoolVec[needToConsider[iR]]]=new_tot;
	
	new_path.push_back(RMap[needToConsider[iR]]);

	if(modifiedDat[needToConsider[iR]].rowsize() < 4){
	  if(*best > new_tot){
	    *best = new_tot;
	    cerr << *best << " ";
	    if(displayARG > 0) optimal_path=new_path;
	  }
	}
	else{
	  //	  if(new_tot+fastLB[needToConsider[iR]] < *best){
	    fastupperbound(modifiedDat[needToConsider[iR]], new_tot, best,new_path,optimal_path,vecNewRMap[needToConsider[iR]]);
	    //	  }
	}
	
	new_path.resize(new_path.size()-1);
      }
      vecNewRMap[needToConsider[iR]].clear();
      modifiedDat[needToConsider[iR]].clear();
      tmpBoolVec[needToConsider[iR]].clear();
    }
  }
  else{
    for(iR=0; iR < inData.rowsize(); iR++){  
      modifiedDat[iR].clear();
      vecNewRMap[iR].clear();
    }
  }
  needToConsider.clear();
}
       
      
      
