// BinMatrix.cpp
//
// Author: Yun S. Song
// October 2004

#include <iostream>
#include <vector>

#include "myMatrix.h"


using namespace std;


// Binary Matrix class functions


// get a row
const vector<bool>& BinMatrix::operator[](unsigned int n) const{
  return mat[n];
}


// get a column
std::vector<bool> BinMatrix::column(unsigned int colnumber) const{
  std::vector<bool> colvec(rowsize());
  for(unsigned int i=0; i < rowsize(); i++)
    colvec[i]=mat[i][colnumber];
  return(colvec);
}

// return number of rows
unsigned int BinMatrix::rowsize() const{
  return mat.size();
}

// return number of columns
unsigned int BinMatrix::colsize() const {
  return (rowsize()==0)? 0 : mat[0].size();
}

unsigned int BinMatrix::colnorm(unsigned int colnumber) const{
  unsigned int tmpsum=0;
  for(unsigned int i=0; i < rowsize(); i++)
    tmpsum += mat[i][colnumber]*mat[i][colnumber];
  return(tmpsum);
}

// clear matrix
void BinMatrix::clear(){
  for(unsigned int i=0; i < rowsize(); i++){
    mat[i].clear();
  }
}

/*
BinMatrix & BinMatrix :: operator=(const BinMatrix &toBeCopied){
  clear();
  mat=toBeCopied.mat;
  return *this;
}
*/

// print matrix
void BinMatrix::display() const
{
  unsigned int i,j;
  for(i = 0; i < rowsize(); i++){
    for(j = 0; j < colsize(); j++)
      cout << mat[i][j] ;
    cout << endl;
  }
}


// unsigned short square Matrix class functions


// get a row
const vector<unsigned short>& USMatrix::operator[](unsigned int n) const{
  return mat[n];
}

// return number of rows
unsigned int USMatrix::size() const{
  return mat.size();
}



// clear matrix
void USMatrix::clear(){
  for(unsigned int i=0; i < size(); i++){
    mat[i].clear();
  }
}

// print matrix
void USMatrix::display() const
{
  unsigned int i,j;
  for(i = 0; i < size(); i++){
    for(j = 0; j < size(); j++)
      cout << mat[i][j] ;
    cout << endl;
  }
}
