// Author: Yun S. Song

#ifndef MY_MATRIX_H
#define MY_MATRIX_H

#include <vector>
using namespace std;

class BinMatrix
{
 public:
  std::vector< vector<bool> > mat; 

  // Constructor
  BinMatrix() {}
  BinMatrix(unsigned int row) : mat(row) {}
  BinMatrix(unsigned int row, unsigned int col) : mat(row){
    for(unsigned int i = 0; i < row; i++)
      mat[i].resize(col);
  }

  //  BinMatrix &operator=(const BinMatrix &toBeCopied);
  
  void resize(unsigned int row, unsigned int col){
    mat.resize(row);
    for(unsigned int i=0; i< row; i++)
      mat[i].resize(col);
  }

  void matresize(unsigned int row, unsigned int col){
    mat.resize(row);
    for(unsigned int i=0; i< row; i++)
      mat[i].resize(col);
  }

  void matresize(unsigned int row){
    mat.resize(row);
  }

  void resize(unsigned int row){
    mat.resize(row);
  }
        
  // Accessors
  const vector<bool>& operator[](unsigned int row) const;
  unsigned int rowsize() const;
  unsigned int colsize() const;
  unsigned int colnorm(unsigned int) const;
  std::vector<bool> column(unsigned int) const;
  void clear() ;
  void display() const;
  
};

// unsigned short square matrix
class USMatrix
{
 public:
  std::vector< vector<unsigned short> > mat; 

  // Constructor
  USMatrix() {}
  USMatrix(unsigned int length) : mat(length) {
    for(unsigned int i = 0; i < length; i++)
      mat[i].resize(length);
  }
  
  void resize(unsigned int length){
    mat.resize(length);
    for(unsigned int i=0; i< length; i++)
      mat[i].resize(length);
  }
        
  // Accessors
  const vector<unsigned short>& operator[](unsigned int row) const;
  unsigned int size() const;
  void clear() ;
  void display() const;
  
};

#endif
