// readseq.cpp
// 
// Author: Yun S. Song
// October 2004


#include <iostream>
#include <fstream>
#include <vector>

#include "readData.h"
#include "basicdefs.h"

using namespace std;

BinMatrix readData(char *fname){
 
  BinMatrix Data;

  // open input file stream
  ifstream inData(fname, ios::in);

  // track column numbers
  unsigned int iCol, previCol=0;

  if(!inData){
      cerr << "ERROR: Sequence data file could not be opened.\n" ;
      exit (1);
  }

  const unsigned int SEQ_LENGTH=10000; // max seq length assumed to be 10000
  bool tempRowArray[SEQ_LENGTH];
  vector<bool> tempRowVec;
  char charData[SEQ_LENGTH];
  unsigned int iRow=0;
  int m;

  inData.getline(charData,SEQ_LENGTH,'\n'); // dummy reading to move to the next line

  while( !inData.eof() ){
    inData.getline(charData,SEQ_LENGTH,'\n');
    iCol=0;
    for(m=0; m < inData.gcount(); m++){
      if(charData[m]==' ') continue;  // in case there is space between columns 
      else{
	if(charData[m]=='0'){
	  tempRowArray[iCol]=0;
	  iCol++;
	}
	else{
	  if(charData[m]=='1'){
	    tempRowArray[iCol]=1;
	    iCol++;
	  }
	}
      }
    }

    if(iRow==0){
      tempRowVec.resize(iCol);  // setting row length
    }
    else{
      if(iCol!= 0 && iCol != previCol){
	cerr << "ERROR: Data contains unequal number of columns.\n";
	exit(1);
      }
    }

    if(iCol!=0){
      // appending the current row to Data matrix
      std::copy(tempRowArray,tempRowArray+iCol,tempRowVec.begin());
      Data.mat.push_back(tempRowVec);
    }

    previCol=iCol;
    iRow++;
  }

  tempRowVec.clear();
  inData.close();

  return(Data);
}


